package GraphicThreads;

import UI.MyPane;
import javafx.application.Platform;
import Back.Tree;
import Back.Node;

import java.io.Serializable;

public class CompareThread<T extends Serializable & Comparable<T> > extends GraphicThread {
    Tree<T> tree2;

    /**
     * konstruktor, priradi pane, z neho tree, tree2
     * zadefinuje sleep time
     * @param _pane smernik na pane na ktorom bude pracovat
     */
    public CompareThread(MyPane _pane) {
        pane = _pane;
        tree = pane.getTree1();
        tree2 = pane.getTree2();
        SLEEP_TIME = 1000;
    }
    /**
     * prerobena porovnavacia funkcia tak aby vykreslovala
     * porovnavanie n1.compareTo(n2)
     * @param n1 vrchol 1
     * @param n2 vrchol 2
     */
    private int threadCompare(Node<T> n1, Node<T> n2 ){

        if ( n1 == null & n2 == null){ return 0; }
        if ( n1 == null) return -1;
        n1.setAdd(true);
        updateTree();
        if ( n2 == null) return 1;
        n2.setAdd(true);
        updateTree();

        if ( n2.getValue() == null & n1.getValue() == null) return 0;
        if ( n1.getValue() != null & n2.getValue() == null) return 1;
        if ( n2.getValue() != null & n1.getValue() == null) return -1;

        if ( n1.getValue().compareTo(n2.getValue()) != 0){
            return n1.getValue().compareTo(n2.getValue());
        }

        if ( n1.getSons() == null & n2.getSons() == null) return 0;
        if ( n1.getSons() != null & n2.getSons() == null) return 1;
        if ( n2.getSons() != null & n1.getSons() == null)return -1;

        int kolko = Math.min(n1.getSons().size(), n2.getSons().size());

        n1.setFind(true);
        n1.setAdd(false);

        n2.setFind(true);
        n2.setAdd(false);
        updateTree();

        for (int i = 0; i < kolko; i++) {

            Node<T> son1 = n1.getSons().get(i);
            Node<T> son2 = n2.getSons().get(i);

            if ( son1 == null & son2 == null){
                continue;
            }

            if ( son1 == null){ return -1; }
            if ( son2 == null){ return 1;}

            if ( threadCompare(son1, son2) != 0) {
                return threadCompare(son1, son2);
            }

        }

        if ( n1.getSons().size() == n2.getSons().size() ){
            return 0;
        }

        return ( n1.getSons().size() > n2.getSons().size())? 1 : -1;
    }

    /**
     * porovna tree a tree2
     * vysledok vypise a caka na uzivatela
     * pokial potvrdi ze si informaciu precital
     */
    @Override
    public void run() {
        int c = threadCompare( tree.getRoot(), tree2.getRoot());

        if ( c == 0 ){
            Platform.runLater(() -> {
                pane.setOk("tree1 = tree2");
            });
        } else if (  c < 0 ) {
            Platform.runLater(() -> {
                pane.setOk("tree1 < tree2");
            });
        } else {
            Platform.runLater(() -> {
                pane.setOk("tree1 > tree2");
            });
        }
    }
}
